using System;

using System.Collections.Generic;
using System.Linq;
using System.Text;

using Android.App;
using Android.Content;
using Android.OS;
using Android.Runtime;
using Android.Views;
using Android.Widget;

namespace iXTankenAndroid
{
    class TankVorgangListAdapter:ArrayAdapter<TankVorgang>
    {
        private List<TankVorgang> items;
 
        public TankVorgangListAdapter(Context context, int textViewResourceId, List<TankVorgang> items):base(context, textViewResourceId, items) 
        {
            this.items = items;
        }

        public override View GetView(int position, View convertView, ViewGroup parent)
        {
            View view = convertView;
            if (view == null) 
            {
                LayoutInflater  vi =  (LayoutInflater)this.Context.GetSystemService("layout_inflater");

                view = vi.Inflate(Resource.Layout.Main_List_Item, null);
            }
            TankVorgang tankVorgang = items[position];
            if (tankVorgang != null)
            {
                TextView datumView = (TextView)view.FindViewById(Resource.Id.Datum);
                TextView infoView  = (TextView)view.FindViewById(Resource.Id.Info);
                if (datumView != null)
                {
                    datumView.Text = tankVorgang.Datum.ToShortDateString();
                }
                if (infoView != null)
                {
                    infoView.Text = tankVorgang.Info;
                }
            }
            return view;
         } 
 
    }
}